/**
 * Created by lei.wang_1 on 2016/11/17.
 */
appModule.directive("replyReport", ["notices", "api", "utils", "$translate", "log", "$timeout", function (notices, api, utils, translate, log, $timeout) {
    return {
        template: `<div class="reportContainer">
                    <div class="subTask">
                        <div class="row">
                            <div class="title" translate="task.info.overview"></div>
                            <div class="items">
                                <section>
                                    <label translate="task.audit.replied"></label>
                                    <bar data="task.ext_data.total_data.replyData" message="task.ext_data.total_data.auditedMsg"></bar>
                                </section>
                                <section>
                                    <label translate="task.audit.no-reply"></label>
                                    <bar data="task.ext_data.total_data.unReplyData" message="task.ext_data.total_data.unReplyCount" enable-click="isAvailableToSendReminder" on-message-click="showUnReplyUser()"></bar>
                                </section>
                                <div class="reminderTip" ng-class="{'show':showRemindSuccess}" translate="task.info.reminder-sent"></div>
                            </div>
                            <a class="lightBtn auditBtn" translate="task.audit.reminder" ng-click="remindToUsers()" ng-show="isAvailableToSendReminder" ></a>
                        </div>
                       
                        <div ng-repeat="subTask in task.ext_data.sub_task_list" class="row">
                            <div class="title" >
                                <span class="serialNumber" ng-bind="$index + 1"></span>
                                <span ng-bind="subTask.title"></span>
                            </div>
                            <div class="items">
                                <section>
                                    <label translate="task.audit.auditor"></label>
                                    <span ng-bind="subTask.auditorName"></span>
                                </section>
                                <section>
                                    <label translate="task.audit.audited"></label>
                                    <bar data="subTask.auditedData" message="subTask.data.auditedMsg"></bar>
                                </section>
                                <section>
                                    <label translate="task.audit.un-audit"></label>
                                    <bar data="subTask.unAuditData" message="subTask.data.unAuditCount"></bar>
                                </section>
                            </div>
                            <button class="lightBtn auditBtn" translate="task.info.audit" ng-show="subTask.isShowAuditBtn" ng-click="auditReply({task:task,subTaskId:subTask.id,e:$event})"></button>
                        </div>
                    </div>

                 </div>`,
        restrict: "AE",
        replace: true,
        scope: {
            task: "=",
            auditReply: "&",
            showReminder: "&",
            sendReminder: "&",
            canSendReminder: "&"
        },
        link: function ($scope, element) {
            var stopWatch = $scope.$watch("task", function (newV) {
                if (!!newV) {
                    if (!newV.ext_data.sub_task_list || newV.ext_data.sub_task_list.length == 0) {
                        return;
                    }
                    var bbsId = newV.id;
                    $scope.getReplyStatics(bbsId);
                } else {
                    $(element).empty();
                }
            });

            var cancelSuccessRemind = null;

            $scope.getReplyStatics = function (bbsId) {
                var currentUserId = api.getCurrentUser().userId;
                api.getReplyStatics(bbsId, null, function (data) {
                    if (data) {
                        utils.applyScope($scope, function () {
                            $scope.task.ext_data.total_data = {
                                unReplyData: [{
                                    width: (data.total_data.unReplyCount * 100 / data.total_data.totalCount) + '%',
                                    index: 0,
                                    class: 'unReply'
                                }],
                                replyData: [{
                                    width: (data.total_data.replyCount * 100 / data.total_data.totalCount) + '%',
                                    index: 0,
                                    class: 'replied'
                                }, {
                                    width: ((data.total_data.replyCount - data.total_data.deniedCount) * 100 / data.total_data.totalCount) + '%',
                                    index: 0,
                                    class: 'passed'
                                }],
                                unReplyCount: data.total_data.unReplyCount,
                                auditedMsg: translate.instant('task.info.audit-msg', {
                                    count: data.total_data.replyCount,
                                    deniedCount: data.total_data.deniedCount
                                })
                            };
                            $scope.isAvailableToSendReminder = $scope.task.ext_data.total_data && $scope.task.ext_data.total_data.unReplyCount > 0 && $scope.canSendReminder();
                            if (data.sub_task_data.length) {
                                data.sub_task_data.forEach(function (item) {
                                    $scope.task.ext_data.sub_task_list.forEach(function (subTask) {
                                        if (item.id == subTask.id) {
                                            subTask.data = item.data;
                                            subTask.auditedData = [{
                                                width: (item.data.AuditedCount * 100 / item.data.totalCount) + '%',
                                                index: 0,
                                                class: 'audited'
                                            }, {
                                                width: (item.data.passedCount * 100 / item.data.totalCount) + '%',
                                                index: 0,
                                                class: 'passed'
                                            }
                                            ];
                                            subTask.unAuditData = [{
                                                width: (item.data.unAuditCount * 100 / item.data.totalCount) + '%',
                                                index: 0,
                                                class: 'unAudited'
                                            }];
                                            subTask.unAuditReply = [{
                                                width: (item.data.unReplyCount * 100 / item.data.totalCount) + '%',
                                                index: 0,
                                                class: 'unReply'
                                            }];
                                            subTask.data.auditedMsg = translate.instant('task.info.audit-msg', {
                                                count: subTask.data.AuditedCount,
                                                deniedCount: subTask.data.deniedCount
                                            });
                                            subTask.isShowAuditBtn = subTask.audit_user_id == currentUserId;
                                        }
                                    });
                                });
                            }

                        });
                    }
                }, function (msg, code) {
                    log.logInfo(`failed to sub task replies, bbs id: ${bbsId}; msg=${msg}; code=${code}`);
                });
            };

            $scope.showUnReplyUser = function () {
                if ($scope.task.ext_data.total_data && $scope.task.ext_data.total_data.unReplyCount > 0) {
                    $scope.showReminder({count: $scope.task.ext_data.total_data.unReplyCount, type: 'un-reply'});
                }
            };

            $scope.remindToUsers = function () {
                $scope.sendReminder({
                    hidePanel: false,
                    callback: $scope.RemindSuccessful
                });
            };

            $scope.RemindSuccessful = function () {
                utils.applyScope($scope, function () {
                    $scope.showRemindSuccess = true;
                });
                if (cancelSuccessRemind) {
                    $timeout.cancel(cancelSuccessRemind);
                }

                cancelSuccessRemind = $timeout(function () {
                    $scope.showRemindSuccess = false;
                }, 2000);
            };

            var offDataUpdate = $scope.$on('dataUpdate', function () {
                var bbsId = $scope.task.id;
                if (bbsId) {
                    $scope.getReplyStatics(bbsId);
                }
            });

            $scope.$on("$destroy", function () {
                stopWatch();
                offDataUpdate();
            });
        }
    };
}]);
